/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.web;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.noip.codebox.logmonitor.config.ConfigFile;
import net.noip.codebox.logmonitor.target.Factory;
import net.noip.codebox.logmonitor.target.IMonitorable;
import net.noip.codebox.logmonitor.target.TargetAccessException;
import net.noip.codebox.logmonitor.web.ResponseBuilder;

public class Controller
extends HttpServlet {
    private static final long serialVersionUID = -1970875009284523737L;
    private static Logger logger = Logger.getLogger("net.noip.codebox.logmonitor.web.Controller");
    public static final String PARAM_REQ_TYPE = "requestType";
    public static final String PARAM_TARGET_ID = "targetId";
    public static final String PARAM_LAST_QUERY = "lastQueryTime";
    public static final String PARAM_LINE_COUNT = "lineCount";
    public static final String REQ_HAS_UPDATED = "hasUpdated";
    public static final String REQ_LIST_TARGETS = "listTargets";
    public static final String REQ_GET_LATEST = "getLatest";
    public static final String REQ_GET_CONFIG = "getConfig";
    private static final String targetsFile = "/WEB-INF/config.xml";
    private Factory factory;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        logger.info("Request params: " + httpServletRequest.getQueryString());
        String string = httpServletRequest.getParameter(PARAM_REQ_TYPE);
        if (string != null) {
            if (REQ_HAS_UPDATED.equalsIgnoreCase(string)) {
                this.processHasUpdated(httpServletRequest, httpServletResponse);
            } else if (REQ_LIST_TARGETS.equalsIgnoreCase(string)) {
                this.processListTargets(httpServletRequest, httpServletResponse);
            } else if (REQ_GET_LATEST.equalsIgnoreCase(string)) {
                this.processGetLatest(httpServletRequest, httpServletResponse);
            } else if (REQ_GET_CONFIG.equalsIgnoreCase(string)) {
                this.processGetConfig(httpServletRequest, httpServletResponse);
            } else {
                ResponseBuilder.makeErrorResponse((HttpServletResponse)httpServletResponse, (String)("Bad Request: Unknown request type parameter '" + string + "'"));
            }
        } else {
            this.getServletContext().getRequestDispatcher("/Main.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private void processGetLatest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            IMonitorable iMonitorable;
            String string = httpServletRequest.getParameter(PARAM_TARGET_ID);
            if (string == null) {
                throw new IllegalArgumentException("getLatest requests must have a targetId parameter");
            }
            String string2 = httpServletRequest.getParameter(PARAM_LINE_COUNT);
            int n = 0;
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("lineCount parameter value must be numeric");
                }
            }
            if ((iMonitorable = this.factory.getTarget(string)) == null) {
                throw new IllegalArgumentException("getLatest request contained an unknown targetId value of '" + string + "'");
            }
            List list = iMonitorable.getLatestEntries(n);
            ResponseBuilder.makeResponseGetLatest((HttpServletResponse)httpServletResponse, (String)string, (List)list);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ResponseBuilder.makeErrorResponse((HttpServletResponse)httpServletResponse, (String)("Bad Request: " + illegalArgumentException.getMessage()));
        }
        catch (TargetAccessException targetAccessException) {
            ResponseBuilder.makeErrorResponse((HttpServletResponse)httpServletResponse, (String)("Target Access Error [" + targetAccessException.getTargetId() + "] " + targetAccessException.getMessage()));
        }
    }

    private void processListTargets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ResponseBuilder.makeResponseListTargets((HttpServletResponse)httpServletResponse, (Factory)this.factory);
    }

    private void processGetConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ResponseBuilder.makeResponseConfigData((HttpServletResponse)httpServletResponse, (Map)this.factory.getConfigData());
    }

    private void processHasUpdated(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            long l;
            IMonitorable iMonitorable;
            String string = httpServletRequest.getParameter(PARAM_TARGET_ID);
            if (string == null) {
                throw new IllegalArgumentException("hasUpdated requests must have a targetId parameter");
            }
            String string2 = httpServletRequest.getParameter(PARAM_LAST_QUERY);
            long l2 = 0L;
            if (string2 != null) {
                try {
                    l2 = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("lastQueryTime parameter value must be numeric");
                }
            }
            if ((iMonitorable = this.factory.getTarget(string)) == null) {
                throw new IllegalArgumentException("hasUpdated request contained an unknown targetId value of '" + string + "'");
            }
            ResponseBuilder.makeResponseHasUpdated((HttpServletResponse)httpServletResponse, (String)string, (long)l, ((l = iMonitorable.lastUpdateTime()) > l2 ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ResponseBuilder.makeErrorResponse((HttpServletResponse)httpServletResponse, (String)("Bad Request: " + illegalArgumentException.getMessage()));
        }
        catch (TargetAccessException targetAccessException) {
            ResponseBuilder.makeErrorResponse((HttpServletResponse)httpServletResponse, (String)("Target Access Error [" + targetAccessException.getTargetId() + "] " + targetAccessException.getMessage()));
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
        try {
            ConfigFile configFile = new ConfigFile(this.getServletContext().getResourceAsStream(targetsFile));
            this.factory = new Factory(configFile);
        }
        catch (IOException iOException) {
            throw new ServletException("Unable to create the Factory object", (Throwable)iOException);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

